import json
import os
import random
import numpy as np

def read_json(file_path):
    with open(file_path, 'r', encoding="utf8") as file:
        data = json.load(file)
    return data

def write_json(file_path, data):
    with open(file_path, 'w', encoding="utf8") as file:
        json.dump(data, file, indent=4, ensure_ascii=False)

def read_txt(file_path):
    with open(file_path, 'r', encoding="utf8") as file:
        data = file.read()
    return data

def write_txt(file_path, data):
    with open(file_path, "w", encoding="utf8") as file:
        file.write(data)

def seed_set(seed):
    random.seed(seed)
    os.environ['PYTHONHASHSEED'] = str(seed)
    np.random.seed(seed)

def is_json(text):
    try:
        json.loads(text)
        return True
    except:
        return False
    
def normalized_sampling(data):
    normalized_data = data / np.sum(data)
    sampled_index = np.random.choice(len(data), size=1, p=normalized_data)
    return sampled_index[0], normalized_data
